/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.value.functor.arithmetic;

import com.cloudera.sqlengine.executor.conversions.ConversionUtil;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.DateTimeFunctorUtil;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.conv.DateTimeConverter;
import com.cloudera.support.exceptions.ErrorException;
import java.sql.Timestamp;

public class TimestampMinusIntFunctor
implements IBinaryArithmeticFunctor {
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Timestamp timestamp = null;
        long l = 0L;
        if (iSqlDataWrapper.getType() == 93) {
            timestamp = iSqlDataWrapper.getTimestamp();
            l = iSqlDataWrapper2.getInteger();
        } else {
            timestamp = iSqlDataWrapper2.getTimestamp();
            l = iSqlDataWrapper.getInteger();
        }
        timestamp = DateTimeFunctorUtil.timestampPlusNum(timestamp, -l);
        ConversionResult conversionResult = new ConversionResult();
        timestamp = DateTimeConverter.toTimestamp(timestamp, conversionResult, eTDataRequest.getColumn().getTypeMetadata().getPrecision());
        ConversionUtil.checkResult(conversionResult, iWarningListener, -1, -1);
        eTDataRequest.getData().setTimestamp(timestamp);
        return false;
    }
}

