/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.dsiext.dataengine;

import com.cloudera.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.dsi.dataengine.utilities.ParameterType;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.dsi.exceptions.BadDefaultParamException;
import com.cloudera.dsi.exceptions.ExecutingException;
import com.cloudera.dsi.exceptions.InvalidArgumentException;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.dsi.exceptions.OperationCanceledException;
import com.cloudera.dsi.exceptions.ParsingException;
import com.cloudera.dsi.exceptions.UtilsException;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtMetadataOnlyResultSet;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.IStatementExecutor;
import com.cloudera.sqlengine.executor.materializer.ETStatementMaterializer;
import com.cloudera.sqlengine.executor.queryplan.ETQueryPlan;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQueryExecutor
implements IQueryExecutor {
    protected AEStatements m_aeStatements;
    protected ILogger m_log;
    private SqlQueryExecutorContext m_context;
    private ExecutionResults m_results;
    private Map<Integer, Map<Integer, ArrayList<ParameterInputValue>>> m_unprocessedPushedValues;
    private Map<Integer, DataWrapper[]> m_pushedValues;
    private ArrayList<ParameterMetadata> m_parameterMetadata = null;

    public SqlQueryExecutor(AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger) throws ErrorException {
        this.m_aeStatements = aEStatements;
        this.m_log = iLogger;
        this.m_context = new SqlQueryExecutorContext(sqlDataEngineContext, this);
        this.prepareResults();
        this.m_unprocessedPushedValues = new HashMap<Integer, Map<Integer, ArrayList<ParameterInputValue>>>();
    }

    public void prepareResults() throws ErrorException {
        this.m_results = SqlQueryExecutor.createMetadataResults(this.m_aeStatements);
    }

    @Override
    public void cancelExecute() throws ErrorException {
        this.m_context.setIsCanceled(true);
    }

    @Override
    public void clearCancel() {
        this.m_context.setIsCanceled(false);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        try {
            this.m_results = new ExecutionResults();
            this.m_context.setWarningListener(iWarningListener);
            assert (this.m_aeStatements.size() == executionContexts.getCount());
            Iterator<IAEStatement> iterator = this.m_aeStatements.getStatementItr();
            Iterator<ExecutionContext> iterator2 = executionContexts.contextIterator();
            while (iterator.hasNext()) {
                Object object;
                ExecutionContext executionContext = iterator2.next();
                for (AEParameter aEParameter : this.m_context.getDataEngineContext().getDynamicParameters()) {
                    object = executionContext.getInputs().get(aEParameter.getIndex() - 1);
                    if (((ParameterInputValue)object).isPushed()) {
                        aEParameter.setInputData(this.getDataForPushedParam(1, aEParameter.getIndex()));
                        continue;
                    }
                    try {
                        aEParameter.setInputData(((ParameterInputValue)object).getData());
                    }
                    catch (UtilsException utilsException) {
                        throw new SQLEngineException(SQLEngineMessageKey.ILLEGAL_ACCESS_PARAMETER_DATA.name(), utilsException);
                    }
                }
                ETQueryPlan eTQueryPlan = new ETQueryPlan(iterator.next());
                IStatementExecutor object22 = new ETStatementMaterializer(this.m_context.getDataEngineContext().getDataEngine().createSqlConverterGenerator(), iWarningListener).materialize(eTQueryPlan);
                object22.registerWarningListener(iWarningListener);
                object = object22.execute(executionContext);
                this.m_results.addExecutionResult((ExecutionResult)object);
            }
        }
        finally {
            this.clearPushedParamData();
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        this.m_pushedValues = null;
        this.m_unprocessedPushedValues = new HashMap<Integer, Map<Integer, ArrayList<ParameterInputValue>>>();
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        try {
            Integer n2;
            ArrayList<ParameterInputValue> arrayList;
            Map<Integer, ArrayList<ParameterInputValue>> map = this.getUnprocessedPushedValues().get(n);
            if (null == map) {
                map = new HashMap<Integer, ArrayList<ParameterInputValue>>();
                this.getUnprocessedPushedValues().put(n, map);
            }
            if (null == (arrayList = map.get(n2 = Integer.valueOf(parameterInputValue.getMetadata().getParameterNumber())))) {
                arrayList = new ArrayList();
                map.put(n2, arrayList);
            }
            arrayList.add(parameterInputValue);
        }
        catch (Exception exception) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, exception.getLocalizedMessage());
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        HashMap<Integer, DataWrapper[]> hashMap = new HashMap<Integer, DataWrapper[]>();
        try {
            for (Map.Entry<Integer, Map<Integer, ArrayList<ParameterInputValue>>> entry : this.getUnprocessedPushedValues().entrySet()) {
                Map<Integer, ArrayList<ParameterInputValue>> map = entry.getValue();
                Integer n = entry.getKey();
                DataWrapper[] dataWrapperArray = new DataWrapper[this.getNumParams() + 1];
                hashMap.put(n, dataWrapperArray);
                for (Map.Entry<Integer, ArrayList<ParameterInputValue>> entry2 : map.entrySet()) {
                    Object object;
                    int n2 = entry2.getKey();
                    ArrayList<ParameterInputValue> arrayList = entry2.getValue();
                    if (arrayList.size() <= 1) {
                        if (arrayList.size() != 1) continue;
                        dataWrapperArray[n2] = arrayList.get(0).getData();
                        continue;
                    }
                    DataWrapper dataWrapper = new DataWrapper();
                    StringBuilder stringBuilder = new StringBuilder(8000);
                    ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
                    int n3 = 0;
                    boolean bl = TypeUtilities.isCharacterType(arrayList.get(0).getMetadata().getTypeMetadata().getType());
                    for (ParameterInputValue parameterInputValue : arrayList) {
                        object = parameterInputValue.getData();
                        Object object2 = ((DataWrapper)object).getObject();
                        if (bl) {
                            stringBuilder.append((String)parameterInputValue.getData().getObject());
                            continue;
                        }
                        byte[] byArray = (byte[])object2;
                        n3 += byArray.length;
                        arrayList2.add(byArray);
                    }
                    if (bl) {
                        dataWrapper.setChar(stringBuilder.toString());
                    } else {
                        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            object = (byte[])iterator.next();
                            byteBuffer.put((byte[])object);
                        }
                        dataWrapper.setBinary(byteBuffer.array());
                    }
                    dataWrapperArray[n2] = dataWrapper;
                }
            }
            if (this.m_context.isCanceled()) {
                throw SQLEngineExceptionFactory.operationCanceledException();
            }
            this.m_pushedValues = hashMap;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, exception.getLocalizedMessage());
        }
    }

    public SqlQueryExecutorContext getContext() {
        return this.m_context;
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        if (null == this.m_parameterMetadata) {
            ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
            List<AEParameter> list = this.m_context.getDataEngineContext().getDynamicParameters();
            for (AEParameter aEParameter : list) {
                IColumn iColumn = aEParameter.getInferredOrSetColumn();
                ParameterMetadata parameterMetadata = new ParameterMetadata(aEParameter.getIndex(), ParameterType.INPUT, iColumn.getTypeMetadata(), iColumn.getColumnLength(), iColumn.getName(), iColumn.isCaseSensitive(), iColumn.getNullable());
                arrayList.add(parameterMetadata);
            }
            this.m_parameterMetadata = arrayList;
        }
        return this.m_parameterMetadata;
    }

    public int getNumberOfParamSets() throws OperationCanceledException {
        return this.getPushedValues().keySet().size();
    }

    public DataWrapper getDataForPushedParam(int n, int n2) throws SQLEngineException, OperationCanceledException, IllegalStateException {
        DataWrapper[] dataWrapperArray = this.getPushedValues().get(n);
        if (null == dataWrapperArray) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_PARAM_SET.name(), new String[]{String.valueOf(n)});
        }
        if (1 > n2 || n2 > dataWrapperArray.length) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_PARAM_NUMBER.name(), new String[]{String.valueOf(n2)});
        }
        DataWrapper dataWrapper = dataWrapperArray[n2];
        assert (null != dataWrapper);
        return dataWrapper;
    }

    @Override
    public int getNumParams() throws ErrorException {
        return this.m_context.getDataEngineContext().getDynamicParameters().size();
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        List<AEParameter> list = this.m_context.getDataEngineContext().getDynamicParameters();
        if (0 < list.size()) {
            for (int i = 0; i < list.size(); ++i) {
                TypeMetadata typeMetadata = map.get(i);
                if (null == typeMetadata && 0 == (typeMetadata = list.get(i).getInferredOrSetColumn().getTypeMetadata()).getType()) {
                    typeMetadata = TypeMetadata.createTypeMetadata(1);
                }
                ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
                if (typeMetadata.isCharacterType() || typeMetadata.isBinaryType()) {
                    try {
                        columnMetadata.setColumnLength(0xFFFFFFFFL);
                    }
                    catch (NumericOverflowException numericOverflowException) {
                        throw new SQLEngineException(SQLEngineMessageKey.INVALID_ARGUMENT.name(), numericOverflowException);
                    }
                }
                list.get(i).setColumn(columnMetadata);
            }
            this.m_aeStatements.reprocessMetadata();
            this.m_parameterMetadata = null;
        }
    }

    private Map<Integer, Map<Integer, ArrayList<ParameterInputValue>>> getUnprocessedPushedValues() throws OperationCanceledException {
        if (this.m_context.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        return this.m_unprocessedPushedValues;
    }

    private Map<Integer, DataWrapper[]> getPushedValues() throws OperationCanceledException, IllegalStateException {
        if (this.m_context.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        if (null == this.m_pushedValues) {
            throw new IllegalStateException("Request for pushed parameter data before finalizePushedParamData() has been called.");
        }
        return this.m_pushedValues;
    }

    private static ExecutionResults createMetadataResults(AEStatements aEStatements) throws ErrorException {
        if (0 == aEStatements.size()) {
            throw new InvalidArgumentException(7, "statements");
        }
        if (1 != aEStatements.size()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("multiple statements");
        }
        ExecutionResults executionResults = new ExecutionResults();
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        while (iterator.hasNext()) {
            ExecutionResult executionResult;
            IAEStatement iAEStatement = iterator.next();
            if (iAEStatement instanceof AEQuery) {
                executionResult = SqlQueryExecutor.createMetadataResult((AEQuery)iAEStatement);
                executionResults.addExecutionResult(executionResult);
                continue;
            }
            if (iAEStatement instanceof AERowCountStatement) {
                executionResult = SqlQueryExecutor.createMetadataResult((AERowCountStatement)iAEStatement);
                executionResults.addExecutionResult(executionResult);
                continue;
            }
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        return executionResults;
    }

    private static ExecutionResult createMetadataResult(AEQuery aEQuery) {
        return new ExecutionResult(new DSIExtMetadataOnlyResultSet(aEQuery.createResultSetColumns()));
    }

    private static ExecutionResult createMetadataResult(AERowCountStatement aERowCountStatement) {
        return new ExecutionResult(new DSISimpleRowCountResult(0L));
    }
}

