/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.jdbc41;

import com.cloudera.dsi.core.interfaces.IConnection;
import com.cloudera.dsi.dataengine.interfaces.IArray;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.jdbc.common.SArray;
import com.cloudera.jdbc.jdbc41.S41ArrayResultSet;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S41Array
extends SArray {
    public S41Array(IArray iArray, IConnection iConnection, ILogger iLogger, IWarningListener iWarningListener) {
        super(iArray, iConnection, iLogger, iWarningListener);
    }

    @Override
    protected Object createArray(long l, int n) throws SQLException {
        try {
            Object object = this.getDSIArray().createArray(l - 1L, n);
            if (2003 == this.getBaseType()) {
                IArray[] iArrayArray = (IArray[])object;
                int n2 = iArrayArray.length;
                IConnection iConnection = this.getParentConnection();
                ILogger iLogger = this.getLogger();
                IWarningListener iWarningListener = this.getWarningListener();
                S41Array[] s41ArrayArray = new S41Array[n2];
                for (int i = 0; i < n2; ++i) {
                    s41ArrayArray[i] = new S41Array(iArrayArray[i], iConnection, iLogger, iWarningListener);
                }
                return s41ArrayArray;
            }
            return object;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, super.getWarningListener());
        }
    }

    @Override
    protected ResultSet createResultSet(long l, int n) throws SQLException {
        if (0L >= l) {
            throw new IndexOutOfBoundsException("" + l);
        }
        IResultSet iResultSet = this.getDSIArray().createResultSet(l - 1L, n);
        assert (null != iResultSet);
        return new S41ArrayResultSet(this, iResultSet, this.getLogger());
    }

    @Override
    protected IConnection getParentConnection() {
        return super.getParentConnection();
    }
}

