/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.Utils;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.logging.Level;

public class KSQLSavepoint
implements Savepoint,
Cloneable {
    private boolean _isValid;
    private final boolean isNamed;
    private int id;
    private String name;

    public KSQLSavepoint(int id) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = true;
        this.isNamed = false;
        this.id = id;
    }

    public KSQLSavepoint(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = true;
        this.isNamed = true;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.name;
    }

    public void invalidate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = false;
    }

    public String getKBName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "JDBC_SAVEPOINT_" + this.id;
    }

    public KSQLSavepoint clone() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KSQLSavepoint savepoint = null;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            savepoint = (KSQLSavepoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            e.printStackTrace();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return savepoint;
    }
}

