/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.gss;

import com.kingbase8.core.KBStream;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ServerErrorMessage;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GssAction
implements PrivilegedAction<Exception> {
    private final KBStream kbStream;
    private final String _host;
    private final String user;
    private final String kerberosServerName;
    private final boolean useSpnego;
    private final GSSCredential clientCredentials;
    private final boolean logServerErrorDetail;

    GssAction(KBStream kbStream, GSSCredential clientCredentials, String _host, String user, String kerberosServerName, boolean useSpnego, boolean logServerErrorDetail) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream = kbStream;
        this.clientCredentials = clientCredentials;
        this._host = _host;
        this.user = user;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kerberosServerName = kerberosServerName;
        this.useSpnego = useSpnego;
        this.logServerErrorDetail = logServerErrorDetail;
    }

    @Override
    public Exception run() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            GSSManager gssManager = GSSManager.getInstance();
            GSSCredential clientCreds = null;
            Oid[] desiredMechs = new Oid[1];
            if (this.clientCredentials == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.useSpnego && GssAction.hasSpnegoSupport(gssManager)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    desiredMechs[0] = new Oid("1.3.6.1.5.5.2");
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    desiredMechs[0] = new Oid("1.2.840.113554.1.2.2");
                }
                GSSName clientName = gssManager.createName(this.user, GSSName.NT_USER_NAME);
                clientCreds = gssManager.createCredential(clientName, 28800, desiredMechs, 1);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                desiredMechs[0] = new Oid("1.2.840.113554.1.2.2");
                clientCreds = this.clientCredentials;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            GSSName serverName = gssManager.createName(this.kerberosServerName + "@" + this._host, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = gssManager.createContext(serverName, desiredMechs[0], clientCreds, 0);
            secContext.requestMutualAuth(true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] inTokenT = new byte[]{};
            byte[] outTokenT = null;
            boolean estlished = false;
            block7: while (!estlished) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                outTokenT = secContext.initSecContext(inTokenT, 0, inTokenT.length);
                if (outTokenT != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINEST, " FE=> Password(GSS Authentication Token)", new Object[0]);
                    this.kbStream.sendChar(112);
                    this.kbStream.sendInteger4(4 + outTokenT.length);
                    this.kbStream.send(outTokenT);
                    this.kbStream.flush();
                }
                if (!secContext.isEstablished()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int response = this.kbStream.receiveChar();
                    switch (response) {
                        case 69: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            int eleng = this.kbStream.receiveInteger4();
                            ServerErrorMessage _errorMsg = new ServerErrorMessage(this.kbStream.receiveErrorString(eleng - 4), null);
                            KBLOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", _errorMsg);
                            return new KSQLException(_errorMsg, this.logServerErrorDetail);
                        }
                        case 82: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            KBLOGGER.log(Level.FINEST, " <=BE AuthenticationGSSContinue", new Object[0]);
                            int leng = this.kbStream.receiveInteger4();
                            int type = this.kbStream.receiveInteger4();
                            inTokenT = this.kbStream.receive(leng - 8);
                            continue block7;
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return new KSQLException(GT.tr("ProtextOutputCallbackol _error.  Session setup failed.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                estlished = true;
            }
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ioException;
        }
        catch (GSSException gssException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)gssException);
        }
        return null;
    }

    private static boolean hasSpnegoSupport(GSSManager gssManager) throws GSSException {
        Oid[] _mechs;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Oid spnego = new Oid("1.3.6.1.5.5.2");
        for (Oid _mech : _mechs = gssManager.getMechs()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!_mech.equals(spnego)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }
}

