/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBcircle
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint centerPoint;
    public double cicleRadius;

    public KBcircle(double x, double y, double r) {
        this(new KBpoint(x, y), r);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBcircle(KBpoint point, double radius) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.centerPoint = point;
        this.cicleRadius = radius;
    }

    public KBcircle(String value) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(value);
    }

    public KBcircle() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBtokenizer t = new KBtokenizer(KBtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.centerPoint = new KBpoint(t.getToken(0));
            this.cicleRadius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (objt instanceof KBcircle) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBcircle circle = (KBcircle)objt;
            return circle.cicleRadius == this.cicleRadius && circle.centerPoint.equals(this.centerPoint);
        }
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBcircle newKBcircle = (KBcircle)super.clone();
        if (newKBcircle.centerPoint != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newKBcircle.centerPoint = (KBpoint)newKBcircle.centerPoint.clone();
        }
        return newKBcircle;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long doubleToLongBits = Double.doubleToLongBits(this.cicleRadius);
        return (int)(doubleToLongBits >>> 32 ^ (long)this.centerPoint.hashCode() ^ doubleToLongBits);
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "<" + this.centerPoint + "," + this.cicleRadius + ">";
    }
}

