/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Parser;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public final class CommandCompleteParser {
    private long _oid;
    private long _rows;

    public long getOid() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._oid;
    }

    public long getRows() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._rows;
    }

    void set(long _oid, long _rows) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._oid = _oid;
        this._rows = _rows;
    }

    public void parse(String status) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!Parser.isDigitAt(status, status.length() - 1)) {
            this.set(0L, 0L);
            return;
        }
        long _oid = 0L;
        long _rows = 0L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int lastSpace = status.lastIndexOf(32);
            if (Parser.isDigitAt(status, lastSpace + 1)) {
                int penultimateSpace;
                _rows = Parser.parseLong(status, lastSpace + 1, status.length());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (Parser.isDigitAt(status, lastSpace - 1) && Parser.isDigitAt(status, (penultimateSpace = status.lastIndexOf(32, lastSpace - 1)) + 1)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _oid = Parser.parseLong(status, penultimateSpace + 1, lastSpace);
                }
            }
        }
        catch (NumberFormatException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unable to parse the _count in command completion tag: {0}.", status), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        this.set(_oid, _rows);
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "CommandStatus{oid=" + this._oid + ", rows=" + this._rows + '}';
    }

    public boolean equals(Object o) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (this == o) {
            v = true;
            return v;
        }
        if (null == o || this.getClass() != o.getClass()) {
            v = false;
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CommandCompleteParser other = (CommandCompleteParser)o;
        if (this._oid != other._oid) {
            return false;
        }
        return this._rows == other._rows;
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _result = (int)(this._oid ^ this._oid >>> 32);
        _result = 31 * _result + (int)(this._rows ^ this._rows >>> 32);
        return _result;
    }
}

