/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.materializer;

import com.cloudera.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AECreateTable;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.exceptions.SQLEngineMemoryException;
import com.cloudera.sqlengine.executor.IStatementExecutor;
import com.cloudera.sqlengine.executor.StatementExecutor;
import com.cloudera.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETTable;
import com.cloudera.sqlengine.executor.etree.statement.ETQuery;
import com.cloudera.sqlengine.executor.etree.statement.ETSearchedDelete;
import com.cloudera.sqlengine.executor.etree.statement.IETRowCountStatement;
import com.cloudera.sqlengine.executor.etree.statement.IETStatement;
import com.cloudera.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.cloudera.sqlengine.executor.materializer.ETDmlMaterializer;
import com.cloudera.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.cloudera.sqlengine.executor.materializer.ETTableMaterializer;
import com.cloudera.sqlengine.executor.materializer.IStatementMaterializer;
import com.cloudera.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.sqlengine.executor.queryplan.IQueryPlan;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;
import com.cloudera.support.exceptions.InvalidOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETStatementMaterializer
extends AEDefaultVisitor<IETStatement>
implements IStatementMaterializer {
    private IQueryPlan m_plan;
    private SqlConverterGenerator m_converterGenerator;
    private IWarningListener m_warningListener;

    public ETStatementMaterializer(SqlConverterGenerator sqlConverterGenerator, IWarningListener iWarningListener) {
        this.m_converterGenerator = sqlConverterGenerator;
        this.m_warningListener = iWarningListener;
    }

    @Override
    public IStatementExecutor materialize(IQueryPlan iQueryPlan) throws ErrorException {
        this.m_plan = iQueryPlan;
        IETStatement iETStatement = null;
        try {
            iETStatement = iQueryPlan.getAETree().acceptVisitor(this);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
        StatementExecutor statementExecutor = new StatementExecutor(iETStatement);
        return statementExecutor;
    }

    @Override
    public ETQuery visit(AEQuery aEQuery) throws ErrorException {
        MaterializerContext materializerContext = new MaterializerContext(this.m_converterGenerator, this.m_warningListener);
        ETRelationalExpr eTRelationalExpr = aEQuery.getOperand().acceptVisitor(new ETRelationalExprMaterializer(this.m_plan, materializerContext));
        ETQuery eTQuery = new ETQuery(eTRelationalExpr);
        materializerContext.setDataNeededAll(eTQuery.getOperand());
        return eTQuery;
    }

    @Override
    public IETStatement visit(AECreateTable aECreateTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("CREATE statement");
    }

    @Override
    public IETStatement visit(AEDelete aEDelete) throws ErrorException {
        MaterializerContext materializerContext = new MaterializerContext(this.m_converterGenerator, this.m_warningListener);
        ETTable eTTable = aEDelete.getTable().acceptVisitor(new ETTableMaterializer(this.m_plan, materializerContext));
        ETBooleanExpr eTBooleanExpr = aEDelete.getCondition().acceptVisitor(new ETBoolExprMaterializer(this.m_plan, materializerContext));
        return new ETSearchedDelete(eTTable, eTBooleanExpr);
    }

    @Override
    public IETStatement visit(AEDropTable aEDropTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("DROP statement");
    }

    @Override
    public IETRowCountStatement visit(AEInsert aEInsert) throws ErrorException {
        return aEInsert.acceptVisitor(new ETDmlMaterializer(this.m_plan, new MaterializerContext(this.m_converterGenerator, this.m_warningListener)));
    }

    @Override
    public IETStatement visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("INSERT default statement");
    }

    @Override
    public IETStatement visit(AEUpdate aEUpdate) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("UPDATE statement");
    }

    @Override
    protected IETStatement defaultVisit(IAENode iAENode) throws ErrorException {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iAENode + " from base AE tree builder class");
    }
}

