/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.util.UUID;

public final class SqlGuidDataWrapper
extends DefaultSqlDataWrapper {
    private UUID m_data;
    private boolean m_isSet = false;

    public UUID getGuid() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public int getType() {
        return -11;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setGuid(UUID uUID) {
        this.m_isSet = true;
        this.m_data = uUID;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case -11: {
                    this.setGuid(dataWrapper.getGuid());
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setGuid(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

