/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor;

import com.cloudera.dsi.dataengine.utilities.CursorType;
import com.cloudera.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.sqlengine.executor.ETResultSet;
import com.cloudera.sqlengine.executor.ETRowCountResult;
import com.cloudera.sqlengine.executor.IStatementExecutor;
import com.cloudera.sqlengine.executor.etree.statement.ETQuery;
import com.cloudera.sqlengine.executor.etree.statement.IETRowCountStatement;
import com.cloudera.sqlengine.executor.etree.statement.IETStatement;
import com.cloudera.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;

public class StatementExecutor
implements IStatementExecutor {
    private IETStatement m_etStatement;

    public StatementExecutor(IETStatement iETStatement) throws ErrorException {
        if (!(iETStatement instanceof ETQuery) && !(iETStatement instanceof IETRowCountStatement)) {
            throw new IllegalArgumentException("Unknown ETree type.");
        }
        this.m_etStatement = iETStatement;
    }

    public ExecutionResult execute(ExecutionContext executionContext) throws ErrorException {
        if (this.m_etStatement.isResultSet()) {
            ETResultSet eTResultSet = new ETResultSet((ETQuery)this.m_etStatement);
            eTResultSet.setCursorType(CursorType.FORWARD_ONLY);
            return new ExecutionResult(eTResultSet);
        }
        IETRowCountStatement iETRowCountStatement = (IETRowCountStatement)this.m_etStatement;
        iETRowCountStatement.execute();
        ETRowCountResult eTRowCountResult = new ETRowCountResult();
        eTRowCountResult.setRowCount(iETRowCountStatement.getRowCount());
        return new ExecutionResult(eTRowCountResult);
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etStatement);
    }
}

