/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree;

import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAENodeList<T extends IAENode>
implements IAENode,
Iterable<T> {
    private ArrayList<T> m_nodeList;
    private IAENode m_parent;

    public AbstractAENodeList() {
        this.m_nodeList = new ArrayList();
        this.m_parent = null;
    }

    public AbstractAENodeList(AbstractAENodeList<? extends T> abstractAENodeList) {
        this.m_nodeList = new ArrayList(abstractAENodeList.getNumChildren());
        this.m_parent = null;
        for (IAENode iAENode : abstractAENodeList.m_nodeList) {
            IAENode iAENode2 = iAENode.copy();
            iAENode2.setParent(this);
            this.m_nodeList.add(iAENode2);
        }
    }

    @Override
    public abstract AbstractAENodeList<T> copy();

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    public Iterator<T> getChildItr() {
        return this.m_nodeList.iterator();
    }

    @Override
    public int getNumChildren() {
        return this.m_nodeList.size();
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AbstractAENodeList)) {
            return false;
        }
        if (iAENode.getNumChildren() != this.m_nodeList.size()) {
            return false;
        }
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        Iterator<T> iterator2 = this.m_nodeList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isEquivalent((IAENode)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getChildItr();
    }

    public void addNode(T t) {
        if (null == t) {
            throw new NullPointerException("The child cannot be null.");
        }
        this.m_nodeList.add(t);
        t.setParent(this);
    }

    public T replaceNode(T t, int n) {
        if (null == t) {
            throw new NullPointerException("The child cannot be null.");
        }
        t.setParent(this);
        return (T)((IAENode)this.m_nodeList.set(n, t));
    }

    public int findNode(T t) {
        int n = 0;
        for (IAENode iAENode : this.m_nodeList) {
            if (iAENode.isEquivalent((IAENode)t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public T getChild(int n) {
        return (T)((IAENode)this.m_nodeList.get(n));
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getLogString());
        Iterator<T> iterator = this.getChildItr();
        if (!iterator.hasNext()) {
            stringBuilder.append("[]");
        } else {
            stringBuilder.append("[").append(((IAENode)iterator.next()).getLogString());
            while (iterator.hasNext()) {
                stringBuilder.append(", ").append(((IAENode)iterator.next()).getLogString());
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

