/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.dataengine;

import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.cloudera.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.cloudera.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.dsi.exceptions.ParsingException;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hivecommon.dataengine.HiveJDBCCoercionHandler;
import com.cloudera.hivecommon.dataengine.HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCCatalogOnlyMetadataSource;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCCatalogSchemaOnlyMetadataSource;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCColumnsMetadataSource;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCSchemaOnlyMetadataSource;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCTablesMetadataSource;
import com.cloudera.hivecommon.dataengine.metadata.HiveJDBCTypeInfoMetadataSource;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.sqlengine.SQLEngineGenericContext;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.sqlengine.dsiext.dataengine.StoredProcedure;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ErrorException;
import java.util.Map;

public class HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata
extends SqlDataEngine {
    private HiveJDBCSettings m_settings;
    private IHiveClient m_hiveClient;
    private HiveJDBCStatement m_statement;
    private HiveJDBCCommonConnection m_connection;
    private AEStatements m_originalAEStatment;
    private SqlDataEngineContext m_originalDataContext;
    private boolean m_isDirectExecuteQuery;
    private ConnSettingRequestMap m_requestMap;

    public HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata(HiveJDBCStatement hiveJDBCStatement, AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, IHiveClient iHiveClient, HiveJDBCSettings hiveJDBCSettings, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(hiveJDBCStatement);
        LogUtilities.logFunctionEntrance(this.getLog(), hiveJDBCStatement);
        this.m_connection = (HiveJDBCCommonConnection)hiveJDBCStatement.getParentConnection();
        this.m_settings = hiveJDBCSettings;
        this.m_hiveClient = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_originalAEStatment = aEStatements;
        this.m_originalDataContext = sqlDataEngineContext;
        this.m_isDirectExecuteQuery = bl;
        this.m_requestMap = connSettingRequestMap;
    }

    @Override
    public ICoercionHandler createCoercionHandler() {
        return new HiveJDBCCoercionHandler(this.m_settings.m_useCustomCoercionMap, this.getLog());
    }

    @Override
    public IScalarFnMetadataHandler createScalarFnMetadataHandler() {
        IScalarFnMetadataHandler iScalarFnMetadataHandler = this.m_connection.getScalarFnMetadataHandler();
        if (null != iScalarFnMetadataHandler) {
            return iScalarFnMetadataHandler;
        }
        return super.createScalarFnMetadataHandler();
    }

    @Override
    public StoredProcedure openProcedure(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, string2, string3);
        return null;
    }

    @Override
    public DSIExtJResultSet openTable(String string, String string2, String string3, OpenTableType openTableType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{string, string2, string3, openTableType});
        return this.m_hiveClient.getTable(string, string2, string3);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        try {
            return super.prepare(string);
        }
        catch (SQLEngineException sQLEngineException) {
            sQLEngineException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_hiveClient.getWarningListener().getLocale());
            LogUtilities.logWarning(sQLEngineException, this.getLog());
            throw sQLEngineException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_PREPARE_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, map, string, string2, bl});
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new HiveJDBCTypeInfoMetadataSource(this.getLog(), this.m_settings);
            }
            case CATALOG_SCHEMA_ONLY: {
                return new HiveJDBCCatalogSchemaOnlyMetadataSource(this.getLog(), this.m_hiveClient);
            }
            case SCHEMA_ONLY: {
                return new HiveJDBCSchemaOnlyMetadataSource(this.getLog());
            }
            case CATALOG_ONLY: {
                return new HiveJDBCCatalogOnlyMetadataSource(this.getLog(), this.m_hiveClient);
            }
            case COLUMNS: {
                return new HiveJDBCColumnsMetadataSource(this.getLog(), map, null, null, this.m_hiveClient, this.m_settings);
            }
            case TABLES: {
                return new HiveJDBCTablesMetadataSource(this.getLog(), null, null, null, this.m_hiveClient, this.m_settings);
            }
            case TABLETYPE_ONLY: {
                return new DSITableTypeOnlyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    @Override
    protected SqlQueryExecutor createQueryExecutor(AEStatements aEStatements) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), aEStatements);
        HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata = new HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata(aEStatements, this.getContext(), this.getLog(), this.m_settings, this.m_hiveClient, this.m_statement, this.m_connection, this.m_originalAEStatment, this.m_originalDataContext, this.m_isDirectExecuteQuery, this.m_requestMap);
        hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata.prepareResults();
        return hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata;
    }
}

