/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.querytranslation;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hivecommon.IServerVersion;
import com.cloudera.hivecommon.IServerVersionUtils;
import com.cloudera.hivecommon.core.CoreUtils;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hivecommon.querytranslation.ScalarFunctionTranslator;
import com.cloudera.impala.core.ImpalaJDBCServerVersion;
import com.cloudera.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.AENodeList;
import com.cloudera.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.cloudera.sqlengine.aeprocessor.aetree.AbstractAENodeList;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESort;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETop;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.Stack;

public class ImpalaQLAENodeVisitor
extends AEDefaultVisitor<String> {
    private SqlQueryExecutor m_executor;
    private boolean m_hasDistinct = false;
    private ExecutionContext m_paramCurrent;
    private ExecutionContexts m_paramList;
    private boolean m_processingSelectList = false;
    private IServerVersion m_serverVersion;
    private IServerVersionUtils m_serverVersionUtils;

    public ImpalaQLAENodeVisitor(ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion) {
        this.m_executor = sqlQueryExecutor;
        this.m_serverVersion = iServerVersion;
        this.m_serverVersionUtils = iServerVersionUtils;
        this.m_paramList = executionContexts;
        if (null != this.m_paramList) {
            this.m_paramCurrent = this.m_paramList.contextIterator().next();
        }
    }

    @Override
    public String visit(AEAdd aEAdd) throws ErrorException {
        if (aEAdd.getTypeMetadata().isCharacterType()) {
            return this.visit(new AEConcat(this.m_executor.getContext().getDataEngineContext().getCoercionHandler(), aEAdd.getLeftOperand(), aEAdd.getRightOperand()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEAdd.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" + ");
        stringBuilder.append(aEAdd.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEAggregate aEAggregate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(aEAggregate.getOperand().acceptVisitor(this));
        if (aEAggregate.getNumChildren() == 3) {
            Iterator<IAENode> iterator = aEAggregate.getChildItr();
            iterator.next();
            iterator.next();
            stringBuilder.append(" GROUP BY " + iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEAnd aEAnd) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(aEAnd.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" AND ").append(aEAnd.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEColumnReference aEColumnReference) throws ErrorException {
        IColumn iColumn = aEColumnReference.getNamedRelationalExpr().getBaseColumn(aEColumnReference.getColumnNum());
        if (this.m_processingSelectList && aEColumnReference.getParent().getParent() instanceof AEProject && CoreUtils.isComplexType(iColumn)) {
            return "";
        }
        String string = aEColumnReference.getNamedRelationalExpr().getCorrelationName();
        String string2 = aEColumnReference.getNamedRelationalExpr().getQTableName().getTableName();
        if (string.length() > 0) {
            return "`" + string + "`.`" + iColumn.getName() + "`";
        }
        if (string2.length() > 0) {
            return "`" + string2 + "`.`" + iColumn.getName() + "`";
        }
        return "`" + iColumn.getName() + "`";
    }

    @Override
    public String visit(AEComparison aEComparison) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(aEComparison.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" ").append((Object)aEComparison.getComparisonOp()).append(" ");
        stringBuilder.append(aEComparison.getRightOperand().acceptVisitor(this)).append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEConcat aEConcat) throws ErrorException {
        Stack<AEValueExpr> stack;
        AEConcat aEConcat2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONCAT(");
        if (aEConcat.getLeftOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getLeftOperand();
            stack = new Stack<AEValueExpr>();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            boolean bl = true;
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(aEValueExpr.acceptVisitor(this));
                bl = false;
            }
        } else {
            stringBuilder.append(aEConcat.getLeftOperand().acceptVisitor(this));
        }
        if (aEConcat.getRightOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getRightOperand();
            stack = new Stack();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                stringBuilder.append(", ").append(aEValueExpr.acceptVisitor(this));
            }
        } else {
            stringBuilder.append(", ").append(aEConcat.getRightOperand().acceptVisitor(this));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
        return "COUNT(*)";
    }

    @Override
    public String visit(AECrossJoin aECrossJoin) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        string = ImpalaQLAENodeVisitor.allowImplicitJoin(this.m_serverVersion) ? ", " : " CROSS JOIN ";
        Iterator<IAENode> iterator = aECrossJoin.getChildItr();
        IAENode iAENode = iterator.next();
        IAENode iAENode2 = iterator.next();
        if (iAENode2 instanceof AEJoin || iAENode2 instanceof AECrossJoin) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HYC00", "Driver not capable", "Impala only supports left associative joins"});
            throw errorException;
        }
        stringBuilder.append(iAENode.acceptVisitor(this));
        stringBuilder.append(string);
        stringBuilder.append(iAENode2.acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEDelete aEDelete) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        stringBuilder.append(aEDelete.getTable().acceptVisitor(this));
        AEBooleanExpr aEBooleanExpr = aEDelete.getCondition();
        if (!(aEBooleanExpr instanceof AEBooleanTrue)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(aEBooleanExpr.acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEDistinct aEDistinct) throws ErrorException {
        this.m_hasDistinct = true;
        return aEDistinct.getOperand().acceptVisitor(this);
    }

    @Override
    public String visit(AEDivide aEDivide) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEDivide.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" / ");
        stringBuilder.append(aEDivide.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEDropTable aEDropTable) throws ErrorException {
        return this.visitChildren(aEDropTable);
    }

    @Override
    public String visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
        return aEGeneralAggrFn.getAggrFnId().name() + "(" + aEGeneralAggrFn.getSetQuantifier().name() + " " + aEGeneralAggrFn.getOperand().acceptVisitor(this) + ")";
    }

    @Override
    public String visit(AEInsert aEInsert) throws ErrorException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        stringBuilder.append(aEInsert.getTable().acceptVisitor(this));
        if (0 != aEInsert.getInsertColumns().getNumChildren()) {
            stringBuilder.append(" (");
            object = aEInsert.getInsertColumns().getChildItr();
            AEValueExpr aEValueExpr = null;
            if (object.hasNext()) {
                stringBuilder.append("`");
                stringBuilder.append(((AEValueExpr)object.next()).getQColumnName().getColName());
                stringBuilder.append("`");
            }
            while (object.hasNext()) {
                aEValueExpr = (AEValueExpr)object.next();
                stringBuilder.append(",");
                stringBuilder.append("`");
                stringBuilder.append(aEValueExpr.getQColumnName().getColName());
                stringBuilder.append("`");
            }
            stringBuilder.append(")");
        }
        object = aEInsert.getRelationalExpr();
        boolean bl = false;
        if (object instanceof AETableConstructor) {
            stringBuilder.append(" VALUES ");
        } else {
            bl = true;
            stringBuilder.append(" ");
        }
        if (null != this.m_paramList) {
            Iterator<ExecutionContext> iterator = this.m_paramList.contextIterator();
            boolean bl2 = false;
            String string = stringBuilder.toString();
            while (iterator.hasNext()) {
                if (bl) {
                    if (bl2) {
                        stringBuilder.append(";").append(string);
                    }
                    bl2 = true;
                    this.m_paramCurrent = iterator.next();
                    stringBuilder.append(object.acceptVisitor(this));
                    continue;
                }
                if (bl2) {
                    stringBuilder.append(",");
                }
                bl2 = true;
                this.m_paramCurrent = iterator.next();
                stringBuilder.append(object.acceptVisitor(this));
            }
        } else {
            stringBuilder.append(object.acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEJoin aEJoin) throws ErrorException {
        String string = aEJoin.getLeftOperand().acceptVisitor(this);
        String string2 = aEJoin.getRightOperand().acceptVisitor(this);
        String string3 = aEJoin.getJoinCondition().acceptVisitor(this);
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append(aEJoin.getJoinType().toString());
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        stringBuilder.append(" ON ");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    @Override
    public String visit(AELiteral aELiteral) throws ErrorException {
        switch (aELiteral.getLiteralType()) {
            case CHARSTR: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(aELiteral.getStringValue(), true) + "'";
            }
            case DECIMAL: 
            case APPROXNUM: 
            case USINT: {
                return aELiteral.getStringValue();
            }
            case NULL: {
                return "NULL";
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return "CAST('" + aELiteral.getStringValue() + "' AS TIMESTAMP)";
            }
        }
        return "";
    }

    @Override
    public String visit(AELikePredicate aELikePredicate) throws ErrorException {
        String string = null;
        String string2 = null;
        if (aELikePredicate.hasEscapeChar()) {
            boolean bl;
            AEValueExpr aEValueExpr = aELikePredicate.getEscapeChar();
            if (!(aEValueExpr instanceof AELiteral) || ((AELiteral)aEValueExpr).getStringValue().length() != 1) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Invalid escape character. Only one character string literals are supported"});
            }
            char c = ((AELiteral)aEValueExpr).getStringValue().charAt(0);
            boolean bl2 = bl = c != '\\';
            if (aELikePredicate.getRightOperand() instanceof AELiteral) {
                string2 = ((AELiteral)aELikePredicate.getRightOperand()).getStringValue();
                if (bl) {
                    string2 = this.replaceEscapeChar(string2, c);
                }
                string2 = "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(string2, false) + "'";
            }
        }
        string = aELikePredicate.getLeftOperand().acceptVisitor(this);
        if (null == string2) {
            string2 = aELikePredicate.getRightOperand().acceptVisitor(this);
        }
        return "(" + string + " LIKE " + string2 + ")";
    }

    @Override
    public String visit(AEInPredicate aEInPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        stringBuilder.append(((AEValueExpr)aEInPredicate.getLeftOperand().getChild(0)).acceptVisitor(this));
        stringBuilder.append(" IN (");
        this.visitChildren(aEInPredicate.getRightOperand(), ", ", stringBuilder);
        stringBuilder.append(") )");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEMultiply aEMultiply) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEMultiply.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" * ");
        stringBuilder.append(aEMultiply.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENullPredicate aENullPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(aENullPredicate.getOperand().acceptVisitor(this));
        stringBuilder.append(" IS NULL)");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENull aENull) throws ErrorException {
        return "NULL";
    }

    @Override
    public String visit(AENegate aENegate) throws ErrorException {
        return "(-" + this.visitChildren(aENegate) + ")";
    }

    @Override
    public String visit(AENot aENot) throws ErrorException {
        return "(NOT " + aENot.getOperand().acceptVisitor(this) + ")";
    }

    @Override
    public String visit(AEOr aEOr) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(aEOr.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" OR ").append(aEOr.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEQuery aEQuery) throws ErrorException {
        return this.visitChildren(aEQuery);
    }

    @Override
    public String visit(AEParameter aEParameter) throws ErrorException {
        ParameterInputValue parameterInputValue = this.m_paramCurrent.getInputs().get(aEParameter.getIndex() - 1);
        DataWrapper dataWrapper = null;
        try {
            dataWrapper = parameterInputValue.isPushed() ? this.m_executor.getDataForPushedParam(1, aEParameter.getIndex()) : parameterInputValue.getData();
            if (dataWrapper.isNull()) {
                return "NULL";
            }
            return this.getParameterValue(dataWrapper);
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HY000", "General error", "Unexpected error accessing parameter data"}, (Throwable)exception);
        }
    }

    @Override
    public String visit(AEProject aEProject) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.m_hasDistinct) {
            stringBuilder.append("DISTINCT ");
            this.m_hasDistinct = false;
        }
        Iterator<IAENode> iterator = aEProject.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        this.m_processingSelectList = true;
        String string2 = iterator.next().acceptVisitor(this);
        this.m_processingSelectList = false;
        return stringBuilder.append(string2).append(" FROM ").append(string).toString();
    }

    @Override
    public String visit(AEProxyColumn aEProxyColumn) throws ErrorException {
        return aEProxyColumn.getReferToValue().acceptVisitor(this);
    }

    @Override
    public String visit(AERename aERename) throws ErrorException {
        return aERename.getOperand().acceptVisitor(this) + " as" + " `" + aERename.getLabel() + "`";
    }

    @Override
    public String visit(AESearchedCase aESearchedCase) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("(CASE ");
        this.visitChildren(aESearchedCase.getWhenClauseList(), " ", stringBuilder);
        AEValueExpr aEValueExpr = aESearchedCase.getElseClause();
        stringBuilder.append(" ELSE ").append(aEValueExpr.acceptVisitor(this));
        stringBuilder.append(" END)");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WHEN ").append(aESearchedWhenClause.getWhenCondition().acceptVisitor(this));
        stringBuilder.append(" THEN ").append(aESearchedWhenClause.getThenExpression().acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESimpleCase aESimpleCase) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("(CASE ");
        stringBuilder.append(aESimpleCase.getCaseOperand().acceptVisitor(this));
        stringBuilder.append((String)this.visit(aESimpleCase.getWhenClauseList()));
        AEValueExpr aEValueExpr = aESimpleCase.getElseOperand();
        stringBuilder.append(" ELSE ").append(aEValueExpr.acceptVisitor(this));
        stringBuilder.append(" END)");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESetClauseList aESetClauseList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = aESetClauseList.getChildItr();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(((AESetClause)iterator.next()).acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESetClause aESetClause) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEColumnReference aEColumnReference = aESetClause.getLeftOperand();
        stringBuilder.append(aEColumnReference.acceptVisitor(this));
        stringBuilder.append(" = ");
        AEValueExpr aEValueExpr = aESetClause.getRightOperand();
        stringBuilder.append(aEValueExpr.acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
        return " WHEN " + aESimpleWhenClause.getWhenExpression().acceptVisitor(this) + " THEN " + aESimpleWhenClause.getThenExpression().acceptVisitor(this);
    }

    @Override
    public String visit(AEScalarFn aEScalarFn) throws ErrorException {
        return new ScalarFunctionTranslator(this, ScalarFunctionTranslator.SERVER_TYPE.IMPALA).translateScalarFunction(aEScalarFn);
    }

    @Override
    public String visit(AESelect aESelect) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(aESelect.getOperand().acceptVisitor(this));
        if (aESelect.getOperand() instanceof AEAggregate) {
            stringBuilder.append(" HAVING ");
        } else {
            stringBuilder.append(" WHERE ");
        }
        stringBuilder.append(aESelect.getCondition().acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESort aESort) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEProject aEProject = (AEProject)aESort.getOperand();
        stringBuilder.append(this.visitProject(aEProject, aESort.getColumnCount()));
        stringBuilder.append(" ORDER BY ");
        boolean bl = true;
        for (AESortSpec aESortSpec : aESort.getSortSpecs()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            AEValueExpr aEValueExpr = (AEValueExpr)aEProject.getProjectionList().getChild(aESortSpec.getColumnNumber());
            if (!(aEValueExpr instanceof AERename)) {
                stringBuilder.append(aEValueExpr.acceptVisitor(this));
            } else {
                stringBuilder.append(aEValueExpr.getName());
            }
            stringBuilder.append(aESortSpec.isAscending() ? " ASC" : " DESC");
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESubtract aESubtract) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aESubtract.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" - ");
        stringBuilder.append(aESubtract.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESubQuery aESubQuery) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(1000);
        if (aESubQuery.hasDerivedColumnList()) {
            IAENode iAENode;
            AETreeWalker aETreeWalker = new AETreeWalker(aESubQuery);
            AEProject aEProject = null;
            int n = 0;
            while (aETreeWalker.hasNext()) {
                iAENode = aETreeWalker.next();
                if (iAENode instanceof AEProject) {
                    aEProject = (AEProject)iAENode;
                    break;
                }
                if (!(iAENode instanceof AESort)) continue;
                n = ((AESort)iAENode).getColumnCount();
            }
            if (null == aEProject) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HY000", "General error", "AETree structure"});
            }
            iAENode = aEProject.getProjectionList();
            Iterator iterator = ((AbstractAENodeList)iAENode).getChildItr();
            int n2 = 0;
            n2 = n > 0 ? n : ((AbstractAENodeList)iAENode).getNumChildren();
            assert (n2 == aESubQuery.getColumnCount());
            for (int i = 0; i < n2; ++i) {
                AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
                String string = aESubQuery.getColumn(i).getName();
                if (aEValueExpr instanceof AERename) {
                    ((AERename)aEValueExpr).setName(string);
                    continue;
                }
                AERename aERename = new AERename(string, aEValueExpr);
                ((AbstractAENodeList)iAENode).replaceNode(aERename, i);
            }
        }
        stringBuilder.append("(");
        stringBuilder.append(aESubQuery.getOperand().acceptVisitor(this));
        stringBuilder.append(")");
        if (aESubQuery.hasCorrelationName()) {
            stringBuilder.append(" AS ");
            stringBuilder.append(aESubQuery.getTableName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETableConstructor aETableConstructor) throws ErrorException {
        Iterator<? extends IAENode> iterator = aETableConstructor.getChildItr();
        StringBuilder stringBuilder = new StringBuilder();
        if (iterator.hasNext()) {
            IAENode iAENode = iterator.next();
            iAENode.setParent(aETableConstructor);
            stringBuilder.append(" ( ");
            stringBuilder.append(iAENode.acceptVisitor(this));
            stringBuilder.append(" ) ");
            while (iterator.hasNext()) {
                iAENode = iterator.next();
                iAENode.setParent(aETableConstructor);
                stringBuilder.append(" , ");
                stringBuilder.append(" ( ");
                stringBuilder.append(iAENode.acceptVisitor(this));
                stringBuilder.append(" ) ");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETable aETable) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEQTableName aEQTableName = aETable.getBaseQTableName();
        if (aEQTableName.hasSchemaName()) {
            stringBuilder.append('`').append(aEQTableName.getSchemaName()).append("`.");
        }
        stringBuilder.append('`').append(aEQTableName.getTableName()).append('`');
        if (aETable.hasCorrelationName()) {
            stringBuilder.append(' ').append('`').append(aETable.getCorrelationName()).append('`');
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETop aETop) throws ErrorException {
        if (aETop.isPercent()) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "TOP PERCENT is not supported."});
        }
        Iterator<IAENode> iterator = aETop.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        String string2 = "LIMIT " + iterator.next().acceptVisitor(this);
        return string + " " + string2;
    }

    @Override
    public String visit(AEValueExprList aEValueExprList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        this.visitChildren(aEValueExprList, ", ", stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append("exists ");
        stringBuilder.append(aEExistsPredicate.getOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<AERelationalExpr> iterator = aEValueSubQuery.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append("(" + iterator.next().acceptVisitor(this) + ")");
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEUnion aEUnion) throws ErrorException {
        String string = aEUnion.getLeftOperand().acceptVisitor(this);
        String string2 = aEUnion.getRightOperand().acceptVisitor(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append(aEUnion.isAllOptPresent() ? " UNION ALL" : " UNION");
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEUpdate aEUpdate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        AETable aETable = aEUpdate.getTable();
        stringBuilder.append(aETable.acceptVisitor(this));
        stringBuilder.append(" SET ");
        Iterator<ExecutionContext> iterator = this.m_paramList.contextIterator();
        if (null != iterator) {
            String string = stringBuilder.toString();
            boolean bl = false;
            while (iterator.hasNext()) {
                this.m_paramCurrent = iterator.next();
                if (bl) {
                    stringBuilder.append(";").append(string);
                }
                bl = true;
                stringBuilder.append(this.getSetClauses(aEUpdate));
            }
        } else {
            stringBuilder.append(this.getSetClauses(aEUpdate));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENodeList<? extends IAENode> aENodeList) throws ErrorException {
        return this.visitChildren(aENodeList);
    }

    @Override
    public String defaultVisit(IAENode iAENode) throws ErrorException {
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", iAENode.getLogString() + " is not supported"});
    }

    private static boolean allowImplicitJoin(IServerVersion iServerVersion) {
        int n = ((ImpalaJDBCServerVersion)iServerVersion).ordinal();
        return ImpalaJDBCServerVersion.Im_1_2_1.ordinal() >= n || ImpalaJDBCServerVersion.Im_2_1_0.ordinal() <= n;
    }

    private static String escapeStringLiteral(String string, boolean bl) {
        if (bl) {
            return string.replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"");
        }
        return string.replace("'", "\\'").replace("\"", "\\\"");
    }

    private String getParameterValue(DataWrapper dataWrapper) throws ErrorException, IncorrectTypeException {
        switch (dataWrapper.getType()) {
            case -5: {
                return dataWrapper.getBigInt().toString();
            }
            case 3: {
                return dataWrapper.getDecimal().toString();
            }
            case 8: {
                return String.valueOf(dataWrapper.getDouble());
            }
            case 6: {
                return String.valueOf(dataWrapper.getFloat());
            }
            case 4: {
                return String.valueOf(dataWrapper.getInteger());
            }
            case -6: {
                return String.valueOf(dataWrapper.getTinyInt());
            }
            case 2: {
                return dataWrapper.getNumeric().toString();
            }
            case 7: {
                return String.valueOf(dataWrapper.getReal());
            }
            case 5: {
                return String.valueOf(dataWrapper.getSmallInt());
            }
            case -7: 
            case 16: {
                return String.valueOf(dataWrapper.getBoolean());
            }
            case -2: {
                return ImpalaQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getBinary()), true);
            }
            case -3: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getVarBinary()), true) + "'";
            }
            case -4: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getLongVarBinary()), true) + "'";
            }
            case -8: 
            case 1: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(dataWrapper.getChar(), true) + "'";
            }
            case -10: 
            case -1: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(dataWrapper.getLongVarChar(), true) + "'";
            }
            case -9: 
            case 12: {
                return "'" + ImpalaQLAENodeVisitor.escapeStringLiteral(dataWrapper.getVarChar(), true) + "'";
            }
            case 91: {
                return "CAST( '" + dataWrapper.getDate().toString() + "' AS TIMESTAMP)";
            }
            case 93: {
                return "CAST( '" + dataWrapper.getTimestamp().toString() + "' AS TIMESTAMP)";
            }
            case -11: 
            case 92: {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Parameter type not supported"});
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Interval types are not supported"});
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HY000", "General error", "Unexpected datatype returned from parameter"});
    }

    private String getSetClauses(AEUpdate aEUpdate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AESetClauseList aESetClauseList = aEUpdate.getSetClauses();
        stringBuilder.append(aESetClauseList.acceptVisitor(this));
        AEBooleanExpr aEBooleanExpr = aEUpdate.getUpdateCondition();
        if (!(aEBooleanExpr instanceof AEBooleanTrue)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(aEBooleanExpr.acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    private String replaceEscapeChar(String string, char c) {
        string = string.replace("\\", "\\\\");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append('\\');
                if (++i >= string.length()) continue;
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private String translateInsertValues(AEInsert aEInsert, String string, int n) throws ErrorException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        IColumn iColumn = null;
        if (0 != aEInsert.getInsertColumns().getNumChildren()) {
            object = (AEValueExpr)aEInsert.getInsertColumns().getChild(n);
            if (null != object) {
                iColumn = ((AEValueExpr)object).getColumn();
            }
        } else {
            iColumn = aEInsert.getTable().getColumn(n);
        }
        object = iColumn.getTypeMetadata().getType();
        String string3 = iColumn.getTypeMetadata().getTypeName();
        if (((Short)object == 1 || (Short)object == -8) && string3.startsWith("CHAR") || ((Short)object == 12 || (Short)object == -9) && string3.startsWith("VARCHAR")) {
            string2 = string3;
        }
        if (null != string2) {
            stringBuilder.append("CAST(");
        }
        stringBuilder.append(string);
        if (null != string2) {
            stringBuilder.append(" AS ");
            stringBuilder.append(string2);
            if (this.m_serverVersionUtils.supportsCharLength(this.m_serverVersion) || this.m_serverVersionUtils.supportsVarcharLength(this.m_serverVersion)) {
                stringBuilder.append("(");
                stringBuilder.append(iColumn.getColumnLength());
                stringBuilder.append(")");
            }
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }

    private String visitProject(AEProject aEProject, int n) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.m_hasDistinct) {
            stringBuilder.append("DISTINCT ");
            this.m_hasDistinct = false;
        }
        Iterator<IAENode> iterator = aEProject.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        IAENode iAENode = iterator.next();
        Iterator<? extends IAENode> iterator2 = iAENode.getChildItr();
        stringBuilder.append(iterator2.next().acceptVisitor(this));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ").append(iterator2.next().acceptVisitor(this));
        }
        return stringBuilder.append(" FROM ").append(string).toString();
    }

    private String visitChildren(IAENode iAENode) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        this.visitChildren(iAENode, stringBuilder);
        return stringBuilder.toString();
    }

    private void visitChildren(IAENode iAENode, StringBuilder stringBuilder) throws ErrorException {
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
    }

    private void visitChildren(IAENode iAENode, String string, StringBuilder stringBuilder) throws ErrorException {
        block5: {
            Iterator<? extends IAENode> iterator = iAENode.getChildItr();
            if (!iterator.hasNext()) break block5;
            if (iAENode.getParent() instanceof AETableConstructor && iAENode.getParent().getParent() instanceof AEInsert) {
                AEInsert aEInsert = (AEInsert)iAENode.getParent().getParent();
                int n = 0;
                stringBuilder.append(this.translateInsertValues(aEInsert, iterator.next().acceptVisitor(this), n));
                ++n;
                while (iterator.hasNext()) {
                    stringBuilder.append(string);
                    stringBuilder.append(this.translateInsertValues(aEInsert, iterator.next().acceptVisitor(this), n));
                    ++n;
                }
            } else {
                String string2 = iterator.next().acceptVisitor(this);
                while (0 == string2.length() && iterator.hasNext()) {
                    string2 = iterator.next().acceptVisitor(this);
                }
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    String string3 = iterator.next().acceptVisitor(this);
                    if (0 == string3.length()) continue;
                    stringBuilder.append(string).append(string3);
                }
            }
        }
    }
}

