/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.conversions;

import com.cloudera.dsi.exceptions.InvalidOperationException;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;

public class ConversionUtil {
    private ConversionUtil() {
    }

    public static final void checkResult(ConversionResult conversionResult, boolean bl, IWarningListener iWarningListener, int n, int n2) throws ErrorException {
        switch (conversionResult.getState()) {
            case SUCCESS: {
                break;
            }
            case DATETIME_OVERFLOW: {
                if (bl) {
                    throw new ErrorException(DiagState.DIAG_DATETIME_OVERFLOW, 7, SQLEngineMessageKey.DATETIME_OVERFLOW.name(), n2, n);
                }
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 7, SQLEngineMessageKey.DATETIME_OVERFLOW.name(), n2, n));
                break;
            }
            case FRAC_TRUNCATION_ROUNDED_UP: 
            case FRAC_TRUNCATION_ROUNDED_DOWN: {
                if (bl) {
                    throw new ErrorException(DiagState.DIAG_FRACTIONAL_TRUNC, 7, SQLEngineMessageKey.FRAC_TRUNCATION.name(), n2, n);
                }
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 7, SQLEngineMessageKey.FRAC_TRUNCATION.name(), n2, n));
                break;
            }
            case INTERVAL_OVERFLOW_TOO_LARGE: 
            case INTERVAL_OVERFLOW_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.INTERVAL_FIELD_OVERFLOW.name(), n2, n);
            }
            case INVALID_CHAR_VAL_FOR_CAST: {
                throw new ErrorException(DiagState.DIAG_INVALID_CHAR_VAL_FOR_CAST, 7, SQLEngineMessageKey.INVALID_CHAR_FOR_CAST.name(), n2, n);
            }
            case INVALID_DATA: {
                throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 7, SQLEngineMessageKey.CONV_LOGIC_ERROR.name(), n2, n);
            }
            case NUMERIC_OUT_OF_RANGE_TOO_LARGE: 
            case NUMERIC_OUT_OF_RANGE_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_NUM_VAL_OUT_OF_RANGE, 7, SQLEngineMessageKey.CONV_NUMERIC_OUT_OF_RANGE.name(), n2, n);
            }
            case RESTRICTED_DATA_TYPE_ATTR_VIOLATION: {
                throw new ErrorException(DiagState.DIAG_RESTRICTED_DATA_TYPE_ATTR_VIOLATION, 7, SQLEngineMessageKey.INVALID_MULTI_FIELD_INETERVAL_CONV.name(), n2, n);
            }
            case STRING_RIGHT_TRUNCATION: {
                if (bl) {
                    throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), n2, n);
                }
                iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), n2, n));
                break;
            }
            default: {
                throw new InvalidOperationException();
            }
        }
    }

    public static final void checkResult(ConversionResult conversionResult, IWarningListener iWarningListener, int n, int n2) throws ErrorException {
        ConversionUtil.checkResult(conversionResult, false, iWarningListener, n, n2);
    }

    public static boolean doConvert(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlConverter iSqlConverter, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper2 = eTDataRequest.getData();
        ConversionResult conversionResult = iSqlConverter.convert(iSqlDataWrapper, iSqlDataWrapper2);
        ConversionUtil.checkResult(conversionResult, iWarningListener, -1, -1);
        boolean bl2 = false;
        if (!iSqlDataWrapper2.isNull()) {
            if (eTDataRequest.getMetadata().isBinaryType()) {
                bl2 = DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper2, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            }
            if (eTDataRequest.getMetadata().isCharacterType()) {
                bl2 = DataRetrievalUtil.retrieveCharData(iSqlDataWrapper2, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            }
        }
        return bl2;
    }
}

