/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common4;

import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SPooledConnection;
import com.cloudera.support.LogUtilities;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public abstract class C4SPooledConnection
extends SPooledConnection {
    private List<StatementEventListener> m_statementlisteners = new ArrayList<StatementEventListener>();

    public C4SPooledConnection(SConnection sConnection) throws SQLException {
        super(sConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.add(statementEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.remove(statementEventListener);
            }
        }
    }

    public void onHandleStatementClose(PreparedStatement preparedStatement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementClosed(new StatementEvent(this, preparedStatement));
        }
    }

    public void onHandleStatementError(PreparedStatement preparedStatement, SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementErrorOccurred(new StatementEvent(this, preparedStatement, sQLException));
        }
    }
}

